﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Configuration;
using System.IO;
using System.Security.Cryptography.X509Certificates;
using Microsoft.Samples.WindowsAzure.ServiceManagement;


namespace ServiceManagement
{
    public partial class ServiceManagementForm : Form
    {
        IServiceManagement channel = null;

        public ServiceManagementForm()
        {
            InitializeComponent();
            ddlResourceType.SelectedIndex = 0;
            ddlSlotType.SelectedIndex = 0;
            txtLog.AppendText(Environment.NewLine);

        }

        private void btnLoadCert_Click(object sender, EventArgs e)
        {
            try
            {
                X509Certificate2 cert = ServiceManagementUtil.GetCertificate(File.ReadAllBytes(ConfigurationManager.AppSettings["CertificateFilePath"]));

                if (cert != null)
                {
                    AddLog(String.Format("Name:{0}", cert.Subject));

                }
            }
            catch (Exception ex)
            {

                MessageBox.Show(ex.Message, "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        #region Display Results
        private void AddLog(string message)
        {
            txtLog.AppendText(String.Format(">{0}{1}",message, Environment.NewLine));

        }

        internal void AddLog(AffinityGroup affinityGroup)
        {
            if (affinityGroup != null)
            {
                AddLog(String.Format("AffinityGroup Name:{0}", affinityGroup.Name));
                AddLog(String.Format("AffinityGroup Description:{0}", affinityGroup.Description));
                AddLog(String.Format("AffinityGroup Location:{0}", affinityGroup.Location));
                AddLog(affinityGroup.HostedServices);
                AddLog(affinityGroup.StorageServices);
            }
        }

        internal void AddLog(AffinityGroupList affinityGroupList)
        {
            if (affinityGroupList != null)
            {
                 AddLog(String.Format("AffinityGroupList contains {0} item(s).", affinityGroupList.Count));
                foreach (AffinityGroup group in affinityGroupList)
                {
                    AddLog(group);
                }
            }
        }

        internal void AddLog(Operation operation)
        {
            if (operation != null)
            {
                AddLog(String.Format("Operation Status for {0} is {1}.", operation.OperationTrackingId, operation.Status));
               
            }
        }
        internal void AddLog(Deployment deployment)
        {
            if (deployment != null)
            {
                AddLog(String.Format("Name:{0}", deployment.Name));
                AddLog(String.Format("Label:{0}", ServiceManagementHelper.DecodeFromBase64String(deployment.Label)));
                AddLog(String.Format("Url:{0}", deployment.Url));
                AddLog(String.Format("Status:{0}", deployment.Status));
                AddLog(String.Format("DeploymentSlot:{0}", deployment.DeploymentSlot));
                AddLog(String.Format("PrivateID:{0}", deployment.PrivateID));
                AddLog(deployment.RoleInstanceList);
                AddLog(deployment.UpgradeStatus);
            }
        }

        internal void AddLog(DeploymentList deploymentList)
        {
            if (deploymentList != null)
            {
                 AddLog(String.Format("DeploymentList contains {0} item(s).", deploymentList.Count));
                foreach (Deployment deployment in deploymentList)
                {
                    AddLog(deployment);
                }
            }
        }

        internal void AddLog(HostedService hostedService)
        {
            if (hostedService != null)
            {
                if (!string.IsNullOrEmpty(hostedService.ServiceName))
                {
                     AddLog(String.Format("StorageService Name:{0}", hostedService.ServiceName));
                }
                 AddLog(String.Format("HostedService Url:{0}", hostedService.Url));
                AddLog(hostedService.HostedServiceProperties);
                AddLog(hostedService.Deployments);
            }
        }

        internal void AddLog(HostedServiceList hostedServiceList)
        {
            if (hostedServiceList != null)
            {
                 AddLog(String.Format("HostedServiceList contains {0} item(s).", hostedServiceList.Count));
                foreach (HostedService service in hostedServiceList)
                {
                    AddLog(service);
                }
            }
        }

        internal void AddLog(HostedServiceProperties hostedServiceProperties)
        {
            if (hostedServiceProperties != null)
            {
                AddLog(String.Format("HostedService Label:{0}", ServiceManagementHelper.DecodeFromBase64String(hostedServiceProperties.Label)));
                 AddLog(String.Format("HostedService Description:{0}", hostedServiceProperties.Description));
                if (!string.IsNullOrEmpty(hostedServiceProperties.AffinityGroup))
                {
                     AddLog(String.Format("HostedService AffinityGroupName:{0}", hostedServiceProperties.AffinityGroup));
                }
                if (!string.IsNullOrEmpty(hostedServiceProperties.Location))
                {
                     AddLog(String.Format("HostedService Location:{0}", hostedServiceProperties.Location));
                }
            }
        }

        internal void AddLog(RoleInstanceList roleInstanceList)
        {
            if (roleInstanceList != null)
            {
                foreach (RoleInstance instance in roleInstanceList)
                {
                     AddLog(String.Format("RoleName: {0}", instance.RoleName));
                     AddLog(String.Format("Role InstanceName: {0}", instance.InstanceName));
                     AddLog(String.Format("Role InstanceStatus: {0}", instance.InstanceStatus));
                }
            }
        }

        internal void AddLog(StorageService storageService)
        {
            if (storageService != null)
            {
                if (!string.IsNullOrEmpty(storageService.ServiceName))
                {
                    AddLog(String.Format("StorageService Name:{0}", storageService.ServiceName));
                }
                AddLog(String.Format("StorageService Url:{0}", storageService.Url));
                if (storageService.StorageServiceKeys != null)
                {
                    AddLog(String.Format("Primary key:{0}", storageService.StorageServiceKeys.Primary));
                    AddLog(String.Format("Secondary key:{0}", storageService.StorageServiceKeys.Secondary));
                }
            }
        }

        internal void AddLog(StorageServiceList storageServiceList)
        {
            if (storageServiceList != null)
            {
                 AddLog(String.Format("StorageServiceList contains {0} item(s).", storageServiceList.Count));
                foreach (StorageService service in storageServiceList)
                {
                    AddLog(service);
                }
            }
        }

        internal void AddLog(UpgradeStatus upgradeStatus)
        {
            if (upgradeStatus != null)
            {
                AddLog(String.Format("UpgradeType: {0}", upgradeStatus.UpgradeType));
                AddLog(String.Format("CurrentUpgradeDomain: {0}", upgradeStatus.CurrentUpgradeDomain));
                AddLog(String.Format("CurrentUpgradeDomainState: {0}", upgradeStatus.CurrentUpgradeDomainState));
            }
        }

        #endregion

       
        

        private void btnExecute_Click(object sender, EventArgs e)
        {
            try
            {
                
                switch (lstOperations.Text)
                {

                    case "Get Hosted Service":
                        GetHostedService();
                        break;
                    case "Get Storage Service":
                        GetStorageService();
                        break;
                    case "Get Affinity Group":
                        GetAffinityGroup();
                        break;
                    case "Get Operation Status":
                        GetOperationStatus();
                        break;

                    case "List Affinity Groups":
                        ListAffinityGroups();
                        break;

                    case "List Storage Services":
                        ListStorageServices();
                        break;
                    case "Get Storage Keys":
                        GetStorageKeys();
                        break;
                    case "Regenerate Keys":
                        RegenrateStorageServiceKeys();
                        break;
                    case "List Hosted Services":
                        ListHostedServices();
                        break;
                    case "Get Deployment":
                        GetDeployment();
                        break;
                    case "Create Deployment":
                        CreateDeployment();
                        break;
                    case "Swap Deployment":
                        SwapDeployment();
                        break;
                    case "Delete Deployment":
                        DeleteDeployment();
                        break;
                    case "Update Deployment Status":
                        UpdateDeploymentStatus();
                        break;
                    case "Change Deployment Config":
                        ChangeDeploymentConfiguration();
                        break;
                   

                        break;
                    default:
                        break;


                }


            }
            catch (Exception ex)
            {

                MessageBox.Show(ex.Message, "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);


            }

        }

        #region Azure Function Calls
        public void ListHostedServices()
        {
            if (txtSubscriptionId.Text.Length > 0 && txtCertificatePath.Text.Length > 0)
            {
                string opid;
                AddLog(ServiceManagementUtil.ListHostedServices(ref channel, txtSubscriptionId.Text, File.ReadAllBytes(txtCertificatePath.Text), out opid));
                txtOpId.Text = opid;
            }
            else
            {
                throw new Exception("Needs SubscriptionId and CertificatePath");
            }
        }
        public void ListStorageServices()
        {
            if (txtSubscriptionId.Text.Length > 0 && txtCertificatePath.Text.Length > 0)
            {
                string opid;
                AddLog(ServiceManagementUtil.ListStorageServices(ref channel, txtSubscriptionId.Text, File.ReadAllBytes(txtCertificatePath.Text), out opid));
                txtOpId.Text = opid;
            }
            else
            {
                throw new Exception("Needs SubscriptionId and CertificatePath");
            }
        }

        public void ListAffinityGroups()
        {
            if (txtSubscriptionId.Text.Length > 0 && txtCertificatePath.Text.Length > 0)
            {
                string opid;
                AddLog(ServiceManagementUtil.ListAffinityGroups(ref channel, txtSubscriptionId.Text, File.ReadAllBytes(txtCertificatePath.Text), out opid));
                txtOpId.Text = opid;
            }
            else
            {
                throw new Exception("Needs SubscriptionId and CertificatePath");
            }
        }

        public void GetHostedService()
        {
            if (txtSubscriptionId.Text.Length > 0 && txtCertificatePath.Text.Length > 0 && txtResourceName.Text.Length > 0)
            {
                string opid;
                AddLog(ServiceManagementUtil.GetHostedServiceWithDetails(ref channel, txtSubscriptionId.Text, txtResourceName.Text, true, File.ReadAllBytes(txtCertificatePath.Text), out opid));
                txtOpId.Text = opid;
            }
            else
            {
                throw new Exception("Needs SubscriptionId, CertificatePath and Resource Name");
            }
        }

        public void GetStorageService()
        {
            if (txtSubscriptionId.Text.Length > 0 && txtCertificatePath.Text.Length > 0 && txtResourceName.Text.Length > 0)
            {
                string opid;
                AddLog(ServiceManagementUtil.GetStorageService(ref channel, txtSubscriptionId.Text, txtResourceName.Text, File.ReadAllBytes(txtCertificatePath.Text), out opid));
                txtOpId.Text = opid;
            }
            else
            {
                throw new Exception("Needs SubscriptionId, CertificatePath and Resource Name");
            }
        }

        public void GetStorageKeys()
        {
            if (txtSubscriptionId.Text.Length > 0 && txtCertificatePath.Text.Length > 0 && txtResourceName.Text.Length > 0)
            {
                string opid;
                AddLog(ServiceManagementUtil.GetStorageKeys(ref channel, txtSubscriptionId.Text, txtResourceName.Text, File.ReadAllBytes(txtCertificatePath.Text), out opid));
                txtOpId.Text = opid;
            }
            else
            {
                throw new Exception("Needs SubscriptionId, CertificatePath and Resource Name");
            }
        }

        public void RegenrateStorageServiceKeys()
        {
            if (txtSubscriptionId.Text.Length > 0 && txtCertificatePath.Text.Length > 0 && txtResourceName.Text.Length > 0 && ddlKeyType.SelectedIndex > 0)
            {
                string opid;
                AddLog(ServiceManagementUtil.RegenerateStorageServiceKeys(ref channel, txtSubscriptionId.Text, txtResourceName.Text, ddlKeyType.Text, File.ReadAllBytes(txtCertificatePath.Text), out opid));
                txtOpId.Text = opid;
            }
            else
            {
                throw new Exception("Needs SubscriptionId, CertificatePath, Resource Name and Key Type");
            }
        }

        public void GetAffinityGroup()
        {
            if (txtSubscriptionId.Text.Length > 0 && txtCertificatePath.Text.Length > 0 && txtResourceName.Text.Length > 0 )
            {
                string opid;
                AddLog(ServiceManagementUtil.GetAffinityGroup(ref channel, txtSubscriptionId.Text, txtResourceName.Text, File.ReadAllBytes(txtCertificatePath.Text), out opid));
                txtOpId.Text = opid;
            }
            else
            {
                throw new Exception("Needs SubscriptionId, CertificatePath, Resource Name ");
            }
        }

        public void GetOperationStatus()
        {
            if (txtSubscriptionId.Text.Length > 0 && txtCertificatePath.Text.Length > 0 && txtOpId.Text.Length > 0)
            {
                string opid;
                AddLog(ServiceManagementUtil.GetOperationStatus(ref channel, txtSubscriptionId.Text, txtOpId.Text, File.ReadAllBytes(txtCertificatePath.Text), out opid));
                txtOpId.Text = opid;
            }
            else
            {
                throw new Exception("Needs SubscriptionId, CertificatePath, OPID ");
            }
        }

        public void GetDeployment()
        {
            if (txtSubscriptionId.Text.Length > 0 && txtCertificatePath.Text.Length > 0 && txtResourceName.Text.Length > 0 )
            {
                if (txtDeploymentName.Text.Length > 0)
                {
                    string opid;
                    AddLog(ServiceManagementUtil.GetDeployment(ref channel, txtSubscriptionId.Text, txtResourceName.Text, txtDeploymentName.Text, File.ReadAllBytes(txtCertificatePath.Text), out opid));
                    txtOpId.Text = opid;
                }
                else
                {
                    string opid;
                    if (ddlSlotType.SelectedIndex > -1)
                    {
                        AddLog(ServiceManagementUtil.GetDeploymentBySlot(ref channel, txtSubscriptionId.Text, txtResourceName.Text, ddlSlotType.Text, File.ReadAllBytes(txtCertificatePath.Text), out opid));
                    }
                    else
                    {
                        AddLog(ServiceManagementUtil.GetDeploymentBySlot(ref channel, txtSubscriptionId.Text, txtResourceName.Text, "production", File.ReadAllBytes(txtCertificatePath.Text), out opid));


                    }
                    txtOpId.Text = opid;

                }
            }
            else
            {
                throw new Exception("Needs SubscriptionId, CertificatePath, Resource Name, Deployment Name or Slot Type ");
            }
        }

        public void CreateDeployment()
        {
            if (txtSubscriptionId.Text.Length > 0 && txtCertificatePath.Text.Length > 0 && txtResourceName.Text.Length > 0 && txtDeploymentName.Text.Length > 0 &&
                txtDeploymentLabel.Text.Length > 0 && txtConfigFilePath.Text.Length > 0 &&  ddlSlotType.SelectedIndex > -1 && txtPackageUri.Text.Length > 0)
            {
                string opid;
                ServiceManagementUtil.CreateOrUpdateDeployment(ref channel, txtSubscriptionId.Text, txtResourceName.Text, txtDeploymentName.Text, txtDeploymentLabel.Text,
                    txtConfigFilePath.Text, ddlSlotType.Text, txtPackageUri.Text, File.ReadAllBytes(txtCertificatePath.Text), out opid);
                txtOpId.Text = opid;
            }
            else
            {
                throw new Exception("Needs SubscriptionId, CertificatePath, Resource Name, Deployment Name, Deployment Label, Config File Path, Deployment Slot and Package Uri ");
            }
        }

        public void SwapDeployment()
        {
            if (txtSubscriptionId.Text.Length > 0 && txtCertificatePath.Text.Length > 0 && txtResourceName.Text.Length > 0 && txtDeploymentName.Text.Length > 0 && txtStagingDeploymentName.Text.Length > 0)
            {
                string opid;
                ServiceManagementUtil.SwapDeployment(ref channel, txtSubscriptionId.Text, txtResourceName.Text, txtDeploymentName.Text, txtStagingDeploymentName.Text, File.ReadAllBytes(txtCertificatePath.Text), out opid);
                txtOpId.Text = opid;
            }
            else
            {
                throw new Exception("Needs SubscriptionId, CertificatePath, Resource Name, Deployment Name, Staging Deployment Name ");
            }
        }

        public void DeleteDeployment()
        {
            if (txtSubscriptionId.Text.Length > 0 && txtCertificatePath.Text.Length > 0 && txtResourceName.Text.Length > 0)
            {
                if (txtDeploymentName.Text.Length > 0)
                {
                    string opid;
                    ServiceManagementUtil.DeleteDeployment(ref channel, txtSubscriptionId.Text, txtResourceName.Text, txtDeploymentName.Text, File.ReadAllBytes(txtCertificatePath.Text), out opid);
                    txtOpId.Text = opid;
                }
                else
                {
                    string opid;
                    if (ddlSlotType.SelectedIndex > -1)
                    {
                        ServiceManagementUtil.DeleteDeploymentBySlot(ref channel, txtSubscriptionId.Text, txtResourceName.Text, ddlSlotType.Text, File.ReadAllBytes(txtCertificatePath.Text), out opid);
                    }
                    else
                    {
                        ServiceManagementUtil.DeleteDeploymentBySlot(ref channel, txtSubscriptionId.Text, txtResourceName.Text, "staging", File.ReadAllBytes(txtCertificatePath.Text), out opid);


                    }
                    txtOpId.Text = opid;

                }
            }
            else
            {
                throw new Exception("Needs SubscriptionId, CertificatePath, Resource Name, Deployment Name or Slot Type ");
            }
        }

        public void UpdateDeploymentStatus()
        {
            if (txtSubscriptionId.Text.Length > 0 && txtCertificatePath.Text.Length > 0 && txtResourceName.Text.Length > 0 && ddlDeploymentStatus.SelectedIndex > -1)
            {
                string opid;
                if (txtDeploymentName.Text.Length > -1)
                {
                    ServiceManagementUtil.UpdateDeploymentStatus(ref channel, txtSubscriptionId.Text, txtResourceName.Text, txtDeploymentName.Text, ddlDeploymentStatus.Text, File.ReadAllBytes(txtCertificatePath.Text), out opid);
                }
                else
                {
                    if (ddlSlotType.SelectedIndex > -1)
                    {
                        ServiceManagementUtil.UpdateDeploymentStatusBySlot(ref channel, txtSubscriptionId.Text, txtResourceName.Text, ddlSlotType.Text, ddlDeploymentStatus.Text, File.ReadAllBytes(txtCertificatePath.Text), out opid);
                    }
                    else
                    {
                        ServiceManagementUtil.UpdateDeploymentStatusBySlot(ref channel, txtSubscriptionId.Text, txtResourceName.Text, "staging", ddlDeploymentStatus.Text, File.ReadAllBytes(txtCertificatePath.Text), out opid);


                    }

                }
                txtOpId.Text = opid;
            }
            else
            {
                throw new Exception("Needs SubscriptionId, CertificatePath, Resource Name, Deployment Status, Deployment Name or Slot Type ");
            }
        }

        public void ChangeDeploymentConfiguration()
        {
            if (txtSubscriptionId.Text.Length > 0 && txtCertificatePath.Text.Length > 0 && txtResourceName.Text.Length > 0 && txtConfigFilePath.Text.Length > 0)
            {
                string opid;
                if (txtDeploymentName.Text.Length > 0)
                {
                    ServiceManagementUtil.ChangeConfiguration(ref channel, txtSubscriptionId.Text, txtResourceName.Text, txtDeploymentName.Text, txtConfigFilePath.Text, File.ReadAllBytes(txtCertificatePath.Text), out opid);
                }
                else
                {
                    if (ddlSlotType.SelectedIndex > -1)
                    {
                        ServiceManagementUtil.ChangeConfigurationBySlot(ref channel, txtSubscriptionId.Text, txtResourceName.Text, ddlSlotType.Text, txtConfigFilePath.Text, File.ReadAllBytes(txtCertificatePath.Text), out opid);
                    }
                    else
                    {
                        ServiceManagementUtil.ChangeConfigurationBySlot(ref channel, txtSubscriptionId.Text, txtResourceName.Text, "staging", txtConfigFilePath.Text, File.ReadAllBytes(txtCertificatePath.Text), out opid);


                    }

                }
                txtOpId.Text = opid;
            }
            else
            {
                throw new Exception("Needs SubscriptionId, CertificatePath, Resource Name, Deployment Name or Slot Type ");
            }
        }
        #endregion

        private void btnClear_Click(object sender, EventArgs e)
        {
            txtLog.Clear();
        }
    }
}
